/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.smtp.SMTPOutputStream;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class SMTPTransport
extends Transport {
    private MimeMessage message;
    private Address[] addresses;
    private Address[] validSentAddr;
    private Address[] validUnsentAddr;
    private Address[] invalidAddr;
    private Hashtable extMap;
    private boolean noAuth = false;
    private String name = "smtp";
    private static String localHostName;
    private static final String[] ignoreList;
    private static final byte[] CRLF;
    private BufferedInputStream serverInput;
    private LineInputStream lineInputStream;
    private OutputStream serverOutput;
    private String lastServerResponse;
    private Socket serverSocket;

    public SMTPTransport(Session session, URLName uRLName) {
        super(session, uRLName);
        if (uRLName != null) {
            this.name = uRLName.getProtocol();
        }
    }

    private String getLocalHost() {
        try {
            if (localHostName == null || localHostName.length() <= 0) {
                localHostName = this.session.getProperty("mail." + this.name + ".localhost");
            }
            if (localHostName == null || localHostName.length() <= 0) {
                localHostName = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return localHostName;
    }

    public synchronized void connect() throws MessagingException {
        try {
            this.noAuth = true;
            super.connect();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.noAuth = false;
            throw throwable;
        }
        Object var2_1 = null;
        this.noAuth = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean protocolConnect(String string, int n, String string2, String string3) throws MessagingException {
        boolean bl;
        block23: {
            boolean bl2;
            String string4 = this.session.getProperty("mail." + this.name + ".ehlo");
            boolean bl3 = string4 == null || !string4.equalsIgnoreCase("false");
            String string5 = this.session.getProperty("mail." + this.name + ".auth");
            boolean bl4 = bl2 = string5 != null && string5.equalsIgnoreCase("true");
            if (this.debug) {
                System.out.println("DEBUG SMTP: useEhlo " + bl3 + ", useAuth " + bl2);
            }
            if (bl2 && (string2 == null || string3 == null)) {
                return false;
            }
            if (n == -1) {
                String string6 = this.session.getProperty("mail." + this.name + ".port");
                n = string6 != null ? Integer.parseInt(string6) : 25;
            }
            if (string == null || string.length() == 0) {
                string = "localhost";
            }
            bl = false;
            this.openServer(string, n);
            if (bl3) {
                bl = this.ehlo(this.getLocalHost());
            }
            if (bl && bl2 && this.supportsExtension("AUTH")) {
                if (this.debug) {
                    System.out.println("DEBUG SMTP: Attempt to authenticate");
                }
                if (this.supportsAuthentication("LOGIN")) {
                    int n2 = this.simpleCommand("AUTH LOGIN");
                    try {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream(byteArrayOutputStream, Integer.MAX_VALUE);
                            if (n2 == 334) {
                                ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(string2));
                                ((OutputStream)bASE64EncoderStream).flush();
                                n2 = this.simpleCommand(byteArrayOutputStream.toByteArray());
                                byteArrayOutputStream.reset();
                            }
                            if (n2 == 334) {
                                ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(string3));
                                ((OutputStream)bASE64EncoderStream).flush();
                                n2 = this.simpleCommand(byteArrayOutputStream.toByteArray());
                                byteArrayOutputStream.reset();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        Object var12_17 = null;
                        if (n2 == 235) break block23;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        if (n2 != 235) {
                            this.closeConnection();
                            return false;
                        }
                        throw throwable;
                    }
                    this.closeConnection();
                    return false;
                }
                if (this.supportsAuthentication("PLAIN")) {
                    int n3 = this.simpleCommand("AUTH PLAIN");
                    try {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream(byteArrayOutputStream, Integer.MAX_VALUE);
                            if (n3 == 334) {
                                ((OutputStream)bASE64EncoderStream).write(0);
                                ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(string2));
                                ((OutputStream)bASE64EncoderStream).write(0);
                                ((OutputStream)bASE64EncoderStream).write(ASCIIUtility.getBytes(string3));
                                ((OutputStream)bASE64EncoderStream).flush();
                                n3 = this.simpleCommand(byteArrayOutputStream.toByteArray());
                            }
                        }
                        catch (IOException iOException) {
                        }
                        Object var12_19 = null;
                        if (n3 == 235) break block23;
                    }
                    catch (Throwable throwable) {
                        Object var12_20 = null;
                        if (n3 != 235) {
                            this.closeConnection();
                            return false;
                        }
                        throw throwable;
                    }
                    this.closeConnection();
                    return false;
                }
            }
        }
        if (!bl) {
            this.helo(this.getLocalHost());
        }
        return true;
    }

    public synchronized void sendMessage(Message message, Address[] addressArray) throws MessagingException, SendFailedException {
        this.checkConnected();
        if (!(message instanceof MimeMessage)) {
            if (this.debug) {
                System.out.println("DEBUG SMTP: Can only send RFC822 msgs");
            }
            throw new MessagingException("SMTP can only send RFC822 messages");
        }
        int n = 0;
        while (n < addressArray.length) {
            if (!(addressArray[n] instanceof InternetAddress)) {
                throw new MessagingException(String.valueOf(addressArray[n]) + " is not an InternetAddress");
            }
            ++n;
        }
        this.message = (MimeMessage)message;
        this.addresses = addressArray;
        try {
            try {
                this.mailFrom();
                this.rcptTo();
                this.message.writeTo(this.data(), ignoreList);
                this.finishData();
                this.notifyTransportListeners(1, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
            }
            catch (IOException iOException) {
                if (this.debug) {
                    iOException.printStackTrace();
                }
                try {
                    this.closeConnection();
                }
                catch (MessagingException messagingException) {}
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                throw new MessagingException("IOException while sending message", iOException);
            }
            Object var5_5 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            throw throwable;
        }
    }

    public synchronized void close() throws MessagingException {
        block3: {
            if (!super.isConnected()) {
                return;
            }
            try {
                if (this.serverSocket == null) break block3;
                this.sendCommand("QUIT");
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.closeConnection();
                throw throwable;
            }
        }
        Object var2_1 = null;
        this.closeConnection();
    }

    private void closeConnection() throws MessagingException {
        block5: {
            try {
                try {
                    if (this.serverSocket != null) {
                        this.serverSocket.close();
                    }
                }
                catch (IOException iOException) {
                    throw new MessagingException("Server Close Failed", iOException);
                }
                Object var2_2 = null;
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (!super.isConnected()) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_3 = null;
                    this.serverSocket = null;
                    this.serverOutput = null;
                    this.serverInput = null;
                    this.lineInputStream = null;
                    if (!super.isConnected()) break block6;
                    super.close();
                }
                throw throwable;
            }
            super.close();
        }
    }

    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            this.sendCommand("NOOP");
            int n = this.readServerResponse();
            if (n >= 0) {
                return true;
            }
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {}
            return false;
        }
        catch (Exception exception) {
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {}
            return false;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.closeConnection();
            return;
        }
        catch (MessagingException messagingException) {
            return;
        }
    }

    private void helo(String string) throws MessagingException {
        if (string != null) {
            this.issueCommand("HELO " + string, 250);
            return;
        }
        this.issueCommand("HELO", 250);
    }

    private boolean ehlo(String string) throws MessagingException {
        String string2 = string != null ? "EHLO " + string : "EHLO";
        this.sendCommand(string2);
        int n = this.readServerResponse();
        if (n == 250) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(this.lastServerResponse));
            this.extMap = new Hashtable();
            try {
                String string3;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (string3.length() < 5) continue;
                    string3 = string3.substring(4);
                    int n2 = string3.indexOf(32);
                    String string4 = "";
                    if (n2 > 0) {
                        string4 = string3.substring(n2 + 1);
                        string3 = string3.substring(0, n2);
                    }
                    this.extMap.put(string3.toUpperCase(), string4);
                }
            }
            catch (IOException iOException) {}
        }
        return n == 250;
    }

    private void mailFrom() throws MessagingException {
        Object object;
        Object object2;
        String string = this.session.getProperty("mail." + this.name + ".from");
        if (string == null || string.length() <= 0) {
            object = this.message != null && (object2 = this.message.getFrom()) != null && ((Address[])object2).length > 0 ? object2[0] : InternetAddress.getLocalAddress(this.session);
            if (object != null) {
                string = ((InternetAddress)object).getAddress();
            } else {
                throw new MessagingException("can't determine local email address");
            }
        }
        object2 = "MAIL FROM:" + this.normalizeAddress(string);
        if (this.supportsExtension("DSN") && (object = this.session.getProperty("mail." + this.name + ".dsn.ret")) != null) {
            object2 = String.valueOf(object2) + " RET=" + (String)object;
        }
        this.issueCommand((String)object2, 250);
    }

    private void rcptTo() throws MessagingException {
        Vector<Address> vector = new Vector<Address>();
        Vector<Address> vector2 = new Vector<Address>();
        int n = -1;
        SendFailedException sendFailedException = null;
        boolean bl = false;
        this.invalidAddr = null;
        this.validUnsentAddr = null;
        this.validSentAddr = null;
        boolean bl2 = false;
        String string = null;
        if (this.supportsExtension("DSN") && (string = this.session.getProperty("mail." + this.name + ".dsn.notify")) != null) {
            bl2 = true;
        }
        int n2 = 0;
        while (n2 < this.addresses.length) {
            String string2 = "RCPT TO:" + this.normalizeAddress(((InternetAddress)this.addresses[n2]).getAddress());
            if (bl2) {
                string2 = String.valueOf(string2) + " NOTIFY=" + string;
            }
            this.sendCommand(string2);
            n = this.readServerResponse();
            switch (n) {
                case 250: 
                case 251: {
                    vector.addElement(this.addresses[n2]);
                    break;
                }
                case 501: 
                case 503: 
                case 550: 
                case 551: 
                case 553: {
                    bl = true;
                    vector2.addElement(this.addresses[n2]);
                    SendFailedException sendFailedException2 = new SendFailedException(this.lastServerResponse);
                    if (sendFailedException == null) {
                        sendFailedException = sendFailedException2;
                        break;
                    }
                    sendFailedException.setNextException(sendFailedException2);
                    break;
                }
                case 450: 
                case 451: 
                case 452: 
                case 552: {
                    bl = true;
                    vector.addElement(this.addresses[n2]);
                    SendFailedException sendFailedException3 = new SendFailedException(this.lastServerResponse);
                    if (sendFailedException == null) {
                        sendFailedException = sendFailedException3;
                        break;
                    }
                    sendFailedException.setNextException(sendFailedException3);
                    break;
                }
                default: {
                    String string3 = this.lastServerResponse;
                    this.issueCommand("RSET", 250);
                    throw new SendFailedException(string3);
                }
            }
            ++n2;
        }
        if (bl) {
            this.invalidAddr = new Address[vector2.size()];
            vector2.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[vector.size()];
            vector.copyInto(this.validUnsentAddr);
        } else {
            this.validSentAddr = this.addresses;
        }
        if (this.debug) {
            if (this.validSentAddr != null && this.validSentAddr.length > 0) {
                System.out.println("Verified Addresses");
                int n3 = 0;
                while (n3 < this.validSentAddr.length) {
                    System.out.println("  " + this.validSentAddr[n3]);
                    ++n3;
                }
            }
            if (this.validUnsentAddr != null && this.validUnsentAddr.length > 0) {
                System.out.println("Valid Unsent Addresses");
                int n4 = 0;
                while (n4 < this.validUnsentAddr.length) {
                    System.out.println("  " + this.validUnsentAddr[n4]);
                    ++n4;
                }
            }
            if (this.invalidAddr != null && this.invalidAddr.length > 0) {
                System.out.println("Invalid Addresses");
                int n5 = 0;
                while (n5 < this.invalidAddr.length) {
                    System.out.println("  " + this.invalidAddr[n5]);
                    ++n5;
                }
            }
        }
        if (bl) {
            block25: {
                if (this.debug) {
                    System.out.println("DEBUG SMTPTransport: Sending failed because of invalid destination addresses");
                }
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, this.message);
                try {
                    this.issueCommand("RSET", 250);
                }
                catch (MessagingException messagingException) {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException2) {
                        if (!this.debug) break block25;
                        messagingException2.printStackTrace();
                    }
                }
            }
            throw new SendFailedException("Invalid Addresses", sendFailedException, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    private OutputStream data() throws MessagingException {
        this.issueCommand("DATA", 354);
        return new SMTPOutputStream(this.serverOutput);
    }

    private void finishData() throws MessagingException {
        this.issueCommand("\r\n.", 250);
    }

    private void openServer(String string, int n) throws MessagingException {
        if (this.debug) {
            System.out.println("\nDEBUG: SMTPTransport trying to connect to host \"" + string + "\", port " + n + "\n");
        }
        this.session.getProperties();
        try {
            this.serverSocket = SocketFetcher.getSocket(string, n, this.session.getProperties(), "mail." + this.name);
            this.serverOutput = new BufferedOutputStream(this.serverSocket.getOutputStream());
            this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
            this.lineInputStream = new LineInputStream(this.serverInput);
            if (this.readServerResponse() != 220) {
                this.serverSocket.close();
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (this.debug) {
                    System.out.println("DEBUG: SMTPTransport could not connect to host \"" + string + "\", port: " + n + "\n");
                }
                throw new MessagingException("Could not connect to SMTP host: " + string + ", port: " + n);
            }
            if (this.debug) {
                System.out.println("DEBUG: SMTPTransport connected to host \"" + string + "\", port: " + n + "\n");
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new MessagingException("Unknown SMTP host: " + string, unknownHostException);
        }
        catch (IOException iOException) {
            throw new MessagingException("Could not connect to SMTP host: " + string + ", port: " + n, iOException);
        }
    }

    private void issueCommand(String string, int n) throws MessagingException {
        this.sendCommand(string);
        if (this.readServerResponse() != n) {
            throw new MessagingException(this.lastServerResponse);
        }
    }

    private int simpleCommand(String string) throws MessagingException {
        this.sendCommand(string);
        return this.readServerResponse();
    }

    private int simpleCommand(byte[] byArray) throws MessagingException {
        this.sendCommand(byArray);
        return this.readServerResponse();
    }

    private void sendCommand(String string) throws MessagingException {
        this.sendCommand(ASCIIUtility.getBytes(string));
    }

    private void sendCommand(byte[] byArray) throws MessagingException {
        if (this.debug) {
            System.out.println("DEBUG SMTP SENT: " + new String(byArray, 0));
        }
        try {
            this.serverOutput.write(byArray);
            this.serverOutput.write(CRLF);
            this.serverOutput.flush();
            return;
        }
        catch (IOException iOException) {
            throw new MessagingException("Can't send command to SMTP host", iOException);
        }
    }

    private int readServerResponse() {
        String string = "";
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            String string2 = null;
            do {
                if ((string2 = this.lineInputStream.readLine()) == null) {
                    return -1;
                }
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            } while (this.isNotLastLine(string2));
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            n = -1;
        }
        if (this.debug) {
            System.out.println("DEBUG SMTP RCVD: " + string);
        }
        if (n != -1 && string != null && string.length() >= 3) {
            try {
                n = Integer.parseInt(string.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                block14: {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {
                        if (!this.debug) break block14;
                        messagingException.printStackTrace();
                    }
                }
                n = -1;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                block15: {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {
                        if (!this.debug) break block15;
                        messagingException.printStackTrace();
                    }
                }
                n = -1;
            }
        } else {
            n = -1;
        }
        this.lastServerResponse = string;
        return n;
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    private boolean isNotLastLine(String string) {
        if (string != null && string.length() > 4) {
            return string.charAt(3) == '-';
        }
        return false;
    }

    private String normalizeAddress(String string) {
        if (!string.startsWith("<") && !string.endsWith(">")) {
            return "<" + string + ">";
        }
        return string;
    }

    private boolean supportsExtension(String string) {
        return this.extMap != null && this.extMap.get(string.toUpperCase()) != null;
    }

    private boolean supportsAuthentication(String string) {
        if (this.extMap == null) {
            return false;
        }
        String string2 = (String)this.extMap.get("AUTH");
        if (string2 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    static {
        ignoreList = new String[]{"Bcc", "Content-Length"};
        CRLF = new byte[]{13, 10};
    }
}

